import { useState, useEffect } from 'react'
import { Award, Users, Shield, Calendar, Building2, FileText, Star, Heart, Phone, Mail, MapPin } from 'lucide-react'
import ImageSlider from '../components/ImageSlider'
import './MyVisits.css'

const sliderImages = [
  '/images/veterinary-1.jpg',
  '/images/veterinary-2.jpg',
  '/images/veterinary-3.jpg',
  '/images/veterinary-4.jpg'
]

function MyVisits() {
  const [visits, setVisits] = useState({
    active: [],
    past: []
  })

  useEffect(() => {
    const saved = localStorage.getItem('vetVisits')
    if (saved) {
      setVisits(JSON.parse(saved))
    } else {
      const defaultVisits = {
        active: [
          {
            id: 1,
            date: '2025-03-25',
            clinic: 'ВетКлиника "Здоровье"',
            diagnosis: 'Профилактический осмотр',
            animal: 'Кот'
          },
          {
            id: 2,
            date: '2025-03-28',
            clinic: 'ВетКлиника "Дружок"',
            diagnosis: 'Вакцинация',
            animal: 'Собака'
          },
          {
            id: 3,
            date: '2025-03-30',
            clinic: 'ВетКлиника "Здоровье"',
            diagnosis: 'Консультация',
            animal: 'Птица'
          }
        ],
        past: [
          {
            id: 4,
            date: '2025-03-15',
            clinic: 'ВетКлиника "Здоровье"',
            diagnosis: 'Профилактический осмотр',
            rating: 5
          },
          {
            id: 5,
            date: '2025-03-10',
            clinic: 'ВетКлиника "Дружок"',
            diagnosis: 'Вакцинация',
            rating: 4
          },
          {
            id: 6,
            date: '2025-03-05',
            clinic: 'ВетКлиника "Здоровье"',
            diagnosis: 'Лечение',
            rating: 5
          }
        ]
      }
      setVisits(defaultVisits)
      localStorage.setItem('vetVisits', JSON.stringify(defaultVisits))
    }

    const interval = setInterval(() => {
      const updated = localStorage.getItem('vetVisits')
      if (updated) {
        setVisits(JSON.parse(updated))
      }
    }, 500)

    return () => clearInterval(interval)
  }, [])

  const rateVisit = (visitId, rating) => {
    const updated = { ...visits }
    const visit = updated.past.find(v => v.id === visitId)
    if (visit) {
      visit.rating = rating
      setVisits(updated)
      localStorage.setItem('vetVisits', JSON.stringify(updated))
    }
  }

  const formatDate = (dateString) => {
    const date = new Date(dateString)
    return date.toLocaleDateString('ru-RU', { day: 'numeric', month: 'long', year: 'numeric' })
  }

  return (
    <div className="my-visits">
      <div className="page-header">
        <div className="header-shapes">
          <div className="shape shape-1"></div>
          <div className="shape shape-2"></div>
          <div className="shape shape-3"></div>
          <div className="shape shape-4"></div>
          <div className="shape shape-5"></div>
        </div>
        <h1>Мои визиты</h1>
        <p>История посещений ветеринарных клиник</p>
      </div>

      <ImageSlider images={sliderImages} />

      <div className="info-cards-section">
        <div className="info-card">
          <div className="info-icon">
            <Award className="info-icon-img" size={32} />
          </div>
          <h3>15+ лет опыта</h3>
          <p>Профессиональная ветеринарная помощь</p>
        </div>
        <div className="info-card">
          <div className="info-icon">
            <Users className="info-icon-img" size={32} />
          </div>
          <h3>5000+ пациентов</h3>
          <p>Довольных владельцев животных</p>
        </div>
        <div className="info-card">
          <div className="info-icon">
            <Shield className="info-icon-img" size={32} />
          </div>
          <h3>Гарантия качества</h3>
          <p>Современное оборудование и методы</p>
        </div>
      </div>

      <div className="visits-section">
        <h2 className="section-title">История визитов</h2>
        {visits.past.length === 0 ? (
          <div className="empty-state">
            <Heart className="empty-icon" size={64} />
            <p>У вас пока нет визитов</p>
          </div>
        ) : (
          <div className="visits-grid">
            {visits.past.map(visit => (
              <div key={visit.id} className="visit-card">
                <div className="visit-header">
                  <h3>{visit.clinic}</h3>
                </div>
                <div className="visit-details">
                  <div className="detail-item">
                    <Calendar className="detail-icon" size={20} />
                    <span>{formatDate(visit.date)}</span>
                  </div>
                  <div className="detail-item">
                    <Building2 className="detail-icon" size={20} />
                    <span>{visit.clinic}</span>
                  </div>
                  <div className="detail-item">
                    <FileText className="detail-icon" size={20} />
                    <span>{visit.diagnosis}</span>
                  </div>
                </div>
                <div className="rating-section">
                  <p className="rating-label">Оцените визит:</p>
                  <div className="rating-stars">
                    {[1, 2, 3, 4, 5].map(star => (
                      <button
                        key={star}
                        className={`star-btn ${visit.rating >= star ? 'filled' : ''}`}
                        onClick={() => rateVisit(visit.id, star)}
                      >
                        <Star className="star-icon" size={24} />
                      </button>
                    ))}
                  </div>
                </div>
              </div>
            ))}
          </div>
        )}
      </div>

      <div className="services-section">
        <h2 className="section-title">Наши услуги</h2>
        <div className="services-grid">
          <div className="service-card">
            <div className="service-icon">
              <Heart className="service-icon-img" size={32} />
            </div>
            <h3>Терапия</h3>
            <p>Лечение заболеваний всех видов животных</p>
          </div>
          <div className="service-card">
            <div className="service-icon">
              <Shield className="service-icon-img" size={32} />
            </div>
            <h3>Вакцинация</h3>
            <p>Профилактика инфекционных заболеваний</p>
          </div>
          <div className="service-card">
            <div className="service-icon">
              <FileText className="service-icon-img" size={32} />
            </div>
            <h3>Диагностика</h3>
            <p>Лабораторные исследования и анализы</p>
          </div>
          <div className="service-card">
            <div className="service-icon">
              <Calendar className="service-icon-img" size={32} />
            </div>
            <h3>Хирургия</h3>
            <p>Операции любой сложности</p>
          </div>
        </div>
      </div>

      <div className="contact-section">
        <h2 className="section-title">Контакты</h2>
        <div className="contact-grid">
          <div className="contact-card">
            <Phone className="contact-card-icon" size={24} />
            <h3>Телефон</h3>
            <p>+7 (495) 123-45-67</p>
            <p>+7 (495) 123-45-68</p>
          </div>
          <div className="contact-card">
            <Mail className="contact-card-icon" size={24} />
            <h3>Email</h3>
            <p>info@vetclinic.ru</p>
            <p>support@vetclinic.ru</p>
          </div>
          <div className="contact-card">
            <MapPin className="contact-card-icon" size={24} />
            <h3>Адрес</h3>
            <p>г. Москва, ул. Ветеринарная, д. 15</p>
            <p>Ежедневно с 9:00 до 21:00</p>
          </div>
        </div>
      </div>
    </div>
  )
}

export default MyVisits

